/*---------------------------------------------------------------------------
 Copyright:      Henning Schaper  mailto: henningschaper@gmx.de
 Author:         Henning Schaper
 Remarks:        none
 known Problems: none
 Version:        v3.3 prefinal    21.06.2014
 Description:    VFD Uhr mit IV-18 im Multiplexbetrieb
 				 Prozessor: Atmel Atmega 32
 				 Features:
 				 - DCF 77 Empfang
 				 - Musikwiedergabe
 					L 	Normal/Shuffle/Repeat Modus
 					L 	Lautstrkeeinstellung
 					L 	MP3/WMA
 					L 	Play/PAuse
 				 - Datum
 				 - Eieruhrfunktion
 				 - Weckerfunktion mit Musik	
 				 
				Geplant:
 				 - SDHC-Card Untersttzung			   
----------------------------------------------------------------------------*/
/*-------------------------------Anschlsse----------------------------------
PORTA Digit Select; LSB recht, MSB links
PORTC Segment Select
          h					// a) PORTC = 0b00000001
         ---				// b) PORTC = 0b00000010
       f| a |d				// c) PORTC = 0b00000100
         ---				// d) PORTC = 0b00001000
       b|   |c				// e) PORTC = 0b00010000
         ---    o g			// f) PORTC = 0b00100000
          e					// g) PORTC = 0b01000000
          					// h) PORTC = 0b10000000
PD0 DCF Signal
PD7 DCF Empfnger aktivieren (active low)
PD5 / PD6 Status Leds

PD2 Taster LSB 	|
PD3	Taster 		|<----74HC148D
PD4 Taster MSB	|

PORTB SPI (SD-Card + VS1003B) / VS1003B Steuerleitungen
PB3 VS1003B_XCS     				
PB0 VS1003B_XRESET  				
PB1 VS1003B_DREQ    				
PB 2VS1003B_XDCS    	
----------------------------------------------------------------------------*/

#include "config.h"
#include <avr/io.h>
#include "MMC_SD.h" 
#include "FAT.h"
#include "VS1003B.h"
#include "dcfroutines.h"
#include <avr/pgmspace.h>
#include <avr/interrupt.h>

//**----------------------------- Variablen ------------------------------**//


#define uint8 unsigned char
#define uint16 unsigned int
#define uint32 unsigned long


//Zhler und Variablendefinition fr Uhrfunktionen
unsigned char display_array [8] = {0,0, 0, 0,0, 0, 0,0 };  	// Display-Buffer													
unsigned char display_counter = 0;
unsigned char dot_count = 0;
unsigned char dot_counter = 1;
unsigned int clock_count = 0;
unsigned char menu_count = 0; 								//0=Clock; 1=Date; 2=Egg; 3=Alarm
unsigned char wecker_active = 0;							//Wecker Flag
unsigned char start_stop = 0;
unsigned int tast_count = 0;
unsigned int light_count = 0;								//Variable fr Timing von Taster 1 (gedrckt halten)

// Variablen fr Eieruhr
struct {
			uint8_t einer:4;								// 4 bit fr Sekunden-Einer
			uint8_t zehner:4;								// 4 bit fr Sekunden-Zehner
		} egg_millisekunde;

struct {
			uint8_t einer:4;								// 4 bit fr Minuten-Einer             
			uint8_t zehner:3;								// 3 bit fr Minuten-Zehner
	} egg_sekunde;
	
struct {
			uint8_t einer:4;								// 4 bit fr Stunden-Einer
			uint8_t zehner:3;								// 3 bit fr Stunden-Zehner
	} egg_minute;
	
	
// Variablen fr Wecker
struct {
			uint8_t einer:4;								// 4 bit fr Stunden-Einer
			uint8_t zehner:2;								// 2 bit fr Stunden-Zehner
	} wecker_stunde;
	
struct {
			uint8_t einer:4;								// 4 bit fr Minuten-Einer
			uint8_t zehner:3;								// 3 bit fr Minuten-Zehner
	} wecker_minute;



// Variablen fr Filesystem und MP3 Wiedergabe
extern uint16 SectorsPerClust;
extern uint16 FirstDataSector;								//struct of file information
extern uint8  FAT32_Enable;
uint8 mode=DEFAULT_MODE;									//repet all by default

struct FileInfoStruct FileInfo;

struct direntry MusicInfo;									//the mp3 file item which will be played

uint8 flag;													//flag of pause
uint16 totalsongs;											//total songs in the root directery on the SD card
uint8 type;													//file type
uint8 track[128];											//stroe the information of songs (bit set indicate songs has been played)


//**----------------------------- Funktionen ------------------------------**//
void dsp(void);
void timecopy(void);
void datecopy (void);
void eggcopy (void);
void weckercopy (void);
void egg_dec (void);
void clock_inc (void);
void dotright_dsp (void);
void dotleft_dsp (void);
void taster (void);

/*----------------------------------------------------------------------------
---------------------- Funktionen fr MP3 Wiedergabe ------------------------*/


void ClearTrackInfo(void)									//clear the array track[128]
{
	uint8 i;
	for(i=0;i<128;i++)track[i] = 0;
}

uint8 SetTrack(uint16 songs)								//set the track bit, return 1 means the song has been played
{
	uint8 byte_offset;
	uint8 bit_offset;
	songs--;
	byte_offset = songs/8;
	bit_offset = songs%8;
	if(track[byte_offset] & (1<<bit_offset))return 1;
	else
	{
		track[byte_offset] |= 1<<bit_offset;
		return 0;
	}
}

void Delay(uint16 n)
{
	while(n--)asm("nop");
}

/*----------------------------------------------------------------------------
---------------------- Timerinitialisierung 1ms CTC--------------------------*/
void Timer1_Initial(void)
{
	//Timer klarmachen, jede Millisekunde ISR
	OCR0 = 250 - 1; 													// (1/16Mhz/64) * 250 = 1ms
																		// --> wegen CTC Delay -1

	TCCR0 |= (1<<WGM01) | (1<<CS00) | (1<<CS01);						// CTC Mode, Prescaler 64
	TIMSK = 0x02;	
}

void PlayMusic(void) 													//<<--- Beinhaltet Taster Abfrage f. menu_count = 0 und 1
{
	uint16 keylen;														//for key processing
	uint16 count;														//data counting
	uint8 i;															//loop variable
	uint16 j;															//loop variable
	uint32 p;															//cluster
	uint32 totalsect;													//cotain the total sector number of a file
	uint16 leftbytes;													//cotain the left bytes number of a file //the last cluster usually not fully occupied by the file
	uint8 *buffer;														//buffer
	uint32 sector;														//recor the current sector to judge the end sector
	uint16 vol=DefaultVolume;											//default volume
	uint16 songs=1;														//play the fist songs by default
	
	uint16 songs_cnt = 0;												//how many songs have been played
	if(totalsongs==0)return;											//if no music file return
	uint32 rand_val;
	ClearTrackInfo();

	next:																//label for "goto"
	if(mode==RANDOM)													//if the mode is shuffle the songs
	{
		songs_cnt++;
		if(songs_cnt == totalsongs && totalsongs<1025)
		{
			ClearTrackInfo();
			songs_cnt = 0;
		}
		rand_val = TCNT0;  												// Zufallszahl aus Timer in rand_val speichern
		Delay((random() && 0x00ff));
		rand_val <<= 16;
		rand_val += TCNT0;
		srandom(rand_val);
		if(totalsongs>1024)
		{
			songs = (uint16)(((random()/214749)*(uint32)totalsongs)/10000)+1;	//create random song number
		}
		while(totalsongs<1025)
		{
			songs = (uint16)(((random()/214749)*(uint32)totalsongs)/10000)+1;	//create random song number
			if(SetTrack(songs) == 0)break;
		}	
	}
	count=0;															//clear count
	flag=1;
	while(count<2048 && (type != MID))									//2048 zeros honoring DREQ befor soft reset
	{																	//midi
		if((VS1003B_PIN & _BV(VS1003B_DREQ))!=0)
		{
			for(j=0;j<32;j++)
			{
				VS1003B_WriteDAT(0x00);									//fill 0
				count++;
			}
			if(count == 2047)break;
		}
	}
	VS1003B_SoftReset();												//soft reset //in case of playing wma files

	#if FIX_DIRECTORY
	Search(PATH,&MusicInfo,&songs,&type);								//find the file
	#else
	Search(&MusicInfo,&songs,&type);									//find the file
	#endif

	p     = MusicInfo.deStartCluster+(((uint32)MusicInfo.deHighClust)<<16);		//the first cluster of the file
		
	totalsect = MusicInfo.deFileSize/512;								//calculate the total sectors
	leftbytes = MusicInfo.deFileSize%512; 								//calculate the left bytes	
	i=0;
	sector=0;
	
	while(1) 
	{
		keylen=0;
    	for(;i<SectorsPerClust;i++)										//a cluster
		{
			buffer=malloc(512);
			FAT_LoadPartCluster(p,i,buffer);							//read a sector
			count=0;
			while(count<512)
			{
				if(flag==0){if(keylen){Delay(100);keylen--;}}
				else if(type == MID){if(keylen){Delay(100);keylen--;}}
				if((VS1003B_PIN & _BV(VS1003B_DREQ))!=0 && flag)		 //send data  honoring DREQ
				{
					for(j=0;j<32;j++)									//32 Bytes each time
					{
						VS1003B_WriteDAT(buffer[count]);
						count++;
					}
					if(keylen)keylen--;						//for key processing
					if(sector == totalsect && count >= leftbytes)				//if this is the end of the file
					{
						if(type == MID)//waiting the midi file was decoded
						{
							count=0;
							while(count<2048)//recommand 2048 zeros honoring DREQ goto next songs
							{
								if((VS1003B_PIN & _BV(VS1003B_DREQ))!=0 )
								{
									for(j=0;j<32;j++)
									{
										VS1003B_WriteDAT(0x00);
										count++;
									}
									if(count == 2047)break;
								}
							}
						}
						i=SectorsPerClust;
						break;
					}		//file ended
					if(count == 511){break;}	//break if a sector was sent
				}
				if (menu_count == 0 || menu_count == 1)
				{
					if(TAST_2 && tast_count ==0) ///&& keylen==0	//key PLAY/PAUSE
			    	{
			    			tast_count=500;
			    			if(flag==0)
			    				flag=1;
			    			else
			    				flag=0;

							//while(TAST_2);
						 	//if(flag)flag=0;
						 	//else flag=1;
						 	//Delay(1000);
				 	}
					else if(TAST_6 && keylen==0) 		//Volume down
	 				{
				    	Delay(100);
	   			 		if(TAST_6) 
						{
							keylen=200;
							vol=vol+((uint16)(1<<8)+1);
					   		if(vol>=0xFEFE) vol=0xFEFE; 
	   			       		else VS1003B_WriteCMD(0x0b,vol);
					 	}
	 			 	}
				 	else if(TAST_7 && keylen==0)			//Volume up
	  			 	{
					 	Delay(100);
				 	 	if(TAST_7) 
					 	{
					 		keylen=200;
					   		vol=vol-((uint16)(1<<8)+1);
					   		if(vol<=0x0101) vol=0x0101;
					   		else VS1003B_WriteCMD(0x0b,vol);
	   			     	}
				  	}
				 	else if(TAST_5) //				next songs
	 			 	{
						Delay(0x7fff);		
						if(TAST_5)
						{
							Delay(0x7fff);
							if(TAST_5)
							{
								while(TAST_5);
								songs++;
								if(songs > totalsongs)songs=1;
								{
									free(buffer);
									//	Delay(0xffff);
									goto next;
								}
							}
						}
	  			 	}
	  			 
				 	else if(TAST_4) //				previous songs
	 			 	{
						Delay(0x7fff);		
						if(TAST_4)
						{
							Delay(0x7fff);
							if(TAST_4)
							{
								while(TAST_4);
								if(songs == 1)songs=totalsongs;
								else songs--;
								{
									free(buffer);
									//	Delay(0xffff);
									goto next;
								}
							}
						}
	  			 	}
				 	else if(TAST_3 && tast_count==0) 		//mode key
	 			 	{
						//Delay(100);		
						//if(TAST_3)
						//{
							//keylen=0xffff;
	 			 		tast_count = 500;
							if(mode==REPET_ALL)
							{
								mode=REPET_ONE;
								//LED1_ON();
								//LED2_OFF();
							}
							else if(mode==REPET_ONE)//next mode is shuffle
							{
								mode=RANDOM;
								//LED1_OFF();
								//LED2_ON();
								srandom(((uint32)TCNT1)<<16);
							}
							else 
							{
								mode=REPET_ALL;
								//LED1_OFF();
								//LED2_OFF();
							}
						//}
	  			 	}
	  			}
			}
			sector++;
			free(buffer);
		}
		i=0;
		p=FAT_NextCluster(p);	//read next cluster
		if(p == 0x0fffffff || p == 0x0ffffff8 || (FAT32_Enable == 0 && p == 0xffff))//no more cluster
		{
				if(mode==REPET_ALL)songs++;
				if(songs>totalsongs)songs=1;
				goto next;
		}
	}
}


/*----------------------------------------------------------------------------
------------------------------Hauptprogramm ---------------------------------*/
void system_init(void)
{
	Direction_LED_and_Switches();	
	Pullups();
	Direction_VFD_Tube_Digit();
	Direction_VFD_Tube_Segment();
	LED1_ON();
	LED2_OFF();
	TUBE_LIGHT_ON();
	
	OSCCAL = 0x00;			//in order to operate some low speed card the initialization should run at lowest speed
	Delay(0xffff);
	MMC_SD_Init();			//SPI initialize
	Delay(0xffff);
	VS1003B_Init();
	MMC_SD_Reset();
	OSCCAL = 0xff;			//normal operation maximum the frequency
	Delay(0xffff);			//wait for stable
	FAT_Init();

	#if FIX_DIRECTORY
		Search(PATH,&MusicInfo,&totalsongs,&type);
	#else
		SearchInit();
		Search(&MusicInfo,&totalsongs,&type);
	#endif

	Timer1_Initial();
	dcf_init();							//Initialisierung des DCF Moduls
	sei();

	LED1_OFF();
	LED2_ON();
}

/*----------------------------------------------------------------------------
------------------------------Hauptprogramm ---------------------------------*/
int main(void)
{
	system_init();
	PlayMusic();			//play songs
	return 0;
}

/*----------------------------------------------------------------------------
-------------------- Interrupt quasi-Hauptprogramm --------------------------*/

ISR(TIMER0_COMP_vect)
{														
		dsp();										// Anzeigen des akt. Displ. Buffer	
		dcf_interrupt();							// DCF Abfrage
		taster();

		if (start_stop==1 && (dot_counter%10 == 0))	// Eieruhr dekrementieren)
		{
			egg_dec();
		}

	switch (menu_count) 							// Kopieren des aktuellen Menpunktes in den Display Buffer
	{
		case 0:	timecopy(); 	break;	
		case 1: datecopy(); 	break;
		case 2: eggcopy(); 		break;
		case 3: weckercopy(); 	break;
	}

	if (PRESSED)
	{
		if(LED1_STATUS_OFF)
		{
			LED1_ON();
			Delay(1000);
			LED1_OFF();
		}
		else if (LED1_STATUS_ON)
		{
			LED1_ON();
		}
			
	}														
																											
	if(dot_counter == 100)							// Trennzeichen alle 100ms .... 
	{																																
		if (wecker_active == 0)	
		{
			dotright_dsp();
		}
		else
		{
			dotleft_dsp();
		}

		dot_counter = 1;												
	}
	else dot_counter++;
	
	if(clock_count == 1000)						    // Zhler fr Uhr auf 1000? (1s/1ms = 1000)
	{												//
		clock_count = 1;						    // ja, Zhler auf 1	
		clock_inc();
		if (flag==1)
		{
			if(mode==RANDOM)
			{
				if(LED1_STATUS_ON)				//LED 1 & 2 abwechselnd blinken lassen
				{
					LED1_OFF();
					LED2_ON();
				}
				else
				{
					LED2_OFF();
					LED1_ON();
				}
			}
			else if (mode==REPET_ONE)
			{
				LED2_ON();
				PORTD ^=(1<<PD5);		//LED1 blinken lassen
			}
			else
			{
				LED1_ON();
				PORTD ^=(1<<PD6); 		//LED2 blinken lassen;
			}			
		}
		else
		{
			LED1_OFF();
			LED2_ON();
		}
											//
													// 										
	}												//
	else clock_count++;								// sonst: weiterzhlen
	
		if (wecker_active == 1)												// Alarm geben fr Wecker??
	{
		if (stunde.einer == wecker_stunde.einer && stunde.zehner == wecker_stunde.zehner &&
			minute.einer == wecker_minute.einer && minute.zehner == wecker_minute.zehner )
			{
				flag = 1;												// Musik an
				TUBE_LIGHT_ON();										// Licht an
				wecker_active = 0;
			}
	}

}

/*----------------------------------------------------------------------------
-----------------------------Display Routine---------------------------------*/
void dsp (void)
{
		switch (display_array[display_counter]) 
		{
			case 0:		PORTC = 0xBE; break;							//
			case 1:		PORTC = 0x0C; break;							//
			case 2:		PORTC = 0x9B; break;							//
			case 3:		PORTC = 0x9D; break;							//
			case 4:		PORTC = 0x2D; break;							//
			case 5:		PORTC = 0xB5; break;							//
			case 6:		PORTC = 0xB7; break;							//	Definition des Zeichensatzes fr
			case 7:		PORTC = 0xAC; break;							//	die VFD Anzeige
			case 8:		PORTC = 0xBF; break;							//
			case 9:		PORTC = 0xBD; break;							//
			case 10:  	PORTC = 0x01; break;							// -		// Trennzeichen
			case 11:  	PORTC = 0x04; break;							//  |		// fr dot_dsp
			case 12:  	PORTC = 0x10; break;							// _		//
			case 13:  	PORTC = 0x02; break;							//|			//
			case 14:	PORTC = 0x00; break;							// Leerzeichen
			case 15:  	PORTC = 0x40; break;							// PUNKT
		}
		switch (display_counter) 									
		{
			case 0:		PORTA = 0x80;  break;							//
			case 1:		PORTA = 0x40;  break;							//
			case 2:		PORTA = 0x20;  break;							//	Multiplexing;
			case 3:		PORTA = 0x10;  break;							//	Zuschalten der jeweiligen Anzeige
			case 4:		PORTA = 0x08;  break;							//
			case 5:		PORTA = 0x04;  break;							//
			case 6:		PORTA = 0x02;  break;							//
			case 7:		PORTA = 0x01;  break;							//			
		}
		display_counter++;												
		if (display_counter == 8)
		{
			display_counter = 0;
		}
		/*digit=digit>>1;													//Multiplexing
		
		if(digit == 0x00)
		{
			digit = 0x80;
			display_counter=0;
		}

		PORTA = digit;
		display_counter++;*/
}

/*----------------------------------------------------------------------------
--------------Aktuelle Zeit in den Display-Buffer kopieren------------------*/
void timecopy (void)
{
	display_array[7] = sekunde.einer;
	display_array[6] = sekunde.zehner;
	display_array[4] = minute.einer;
	display_array[3] = minute.zehner;
	display_array[1] = stunde.einer;
	display_array[0] = stunde.zehner;
}

/*----------------------------------------------------------------------------
-------------Aktuelles Datum in den Display-Buffer kopieren-----------------*/
void datecopy (void)
{
	display_array[7] = jahr.einer;
	display_array[6] = jahr.zehner;
	display_array[5] = 10;
	display_array[4] = monat.einer;
	display_array[3] = monat.zehner;
	display_array[2] = 10;
	display_array[1] = tag.einer;
	display_array[0] = tag.zehner;
}

/*----------------------------------------------------------------------------
-------------Aktuelles Datum in den Display-Buffer kopieren-----------------*/
void eggcopy (void)
{
	display_array[7] = egg_millisekunde.einer;
	display_array[6] = egg_millisekunde.zehner;
	display_array[5] = 15;
	display_array[4] = egg_sekunde.einer;
	display_array[3] = egg_sekunde.zehner;
	display_array[2] = 15;
	display_array[1] = egg_minute.einer;
	display_array[0] = egg_minute.zehner;
}

/*----------------------------------------------------------------------------
--------------Aktuelle Zeit in den Display-Buffer kopieren------------------*/
void weckercopy (void)
{
	display_array[7] = 0;
	display_array[6] = 0;
	display_array[5] = 12;							// Unterstrich als Trennzeichen
	display_array[4] = wecker_minute.einer;
	display_array[3] = wecker_minute.zehner;
	display_array[2] = 12;
	display_array[1] = wecker_stunde.einer;
	display_array[0] = wecker_stunde.zehner;
}

/*----------------------------------------------------------------------------
-------------------------Eieruhr dekrementieren-----------------------------*/
void egg_dec (void)
{	
	if(start_stop == 1)													// Start? dann LOS!
	{
		if (egg_millisekunde.einer > 0)
		egg_millisekunde.einer--;
		else
		{
			egg_millisekunde.einer = 9;
			if (egg_millisekunde.zehner > 0)
				egg_millisekunde.zehner--;
			else
			{
				egg_millisekunde.zehner = 9;
				if (egg_sekunde.einer > 0)
					egg_sekunde.einer--;
				else
				{
					egg_sekunde.einer = 9;
					if (egg_sekunde.zehner > 0)
						egg_sekunde.zehner--;
					else
					{
						egg_sekunde.zehner = 5;
						if(egg_minute.einer > 0)
							egg_minute.einer--;
						else
						{
							egg_minute.einer = 9;
							if(egg_minute.zehner > 0)
							egg_minute.zehner--;
							else
							{
								start_stop = 0;							// Uhr Abgelaufen - STOP!
								egg_millisekunde.einer = 0;
								egg_millisekunde.zehner = 0;
								egg_sekunde.einer = 0;					// Alles auf NULL
								egg_sekunde.zehner = 0;
								egg_minute.einer = 0;
								egg_minute.zehner = 0;				
								
								flag = 1;								// Spiele Musik
								TUBE_LIGHT_ON();						// Licht an
								
							}	
						}
					}
				}
			}
		}
	}
}

/*----------------------------------------------------------------------------
---------------------------Uhr inkrementieren-------------------------------*/
void clock_inc (void)				
{
	if (sekunde.einer < 9)											
		sekunde.einer++;
	else
	{
		sekunde.einer = 0;			
		if (sekunde.zehner < 5)				
			sekunde.zehner++;
		else																							// Sekundenberlauf (59)
		{
			sekunde.zehner = 0;
			if (minute.einer < 9)
				minute.einer++;
			else
			{
				minute.einer = 0;
				if (minute.zehner < 5)
					minute.zehner++;
				else																					// Minutenberlauf (59)
				{
					minute.zehner = 0;
					if ((stunde.einer == 3) && (stunde.zehner == 2))									// Stunde = 23
					{
						stunde.einer = 0;
						stunde.zehner = 0;
						
						if (monat.wochentag == 7) 														// Wochentag weiterzhlen
							monat.wochentag = 1;
						else
							monat.wochentag++;
						
						if (((monat.zehner == 0) && ((monat.einer == 1) || (monat.einer == 3) || (monat.einer == 5) || (monat.einer == 7) || (monat.einer == 8))) || 	((monat.zehner == 1) && (monat.einer == 0)))								
																										// Monat mit 31 Tagen (nicht Dez)
							
							if ((tag.einer == 1) && (tag.zehner == 3))								
							{
								tag.einer = 1;
								tag.zehner = 0;
								monat.einer++;
							}
							else
								if (tag.einer == 9)													
								{
									tag.einer = 0;
									tag.zehner++;
								}
								else
									tag.einer++;														
						
						else
							if ((monat.einer == 2) && (monat.zehner == 0))							// Monat Februar
							{
								if (((jahr.einer + (jahr.zehner * 10)) % 4) == 0)					// Schaltjahrcheck
									if ((tag.einer == 9) && (tag.zehner == 2))						// Schaltjahr
									{
										tag.einer = 1;
										tag.zehner = 0;
										monat.einer = 3;
									}
									else if (tag.einer == 9)
										{
											tag.einer = 0;
											tag.zehner++;
										}
										  else
											tag.einer++;
								else																	// kein Schaltjahr
									if ((tag.einer == 8) && (tag.zehner == 2))
									{
										tag.einer = 1;
										tag.zehner = 0;
										monat.einer = 3;
									}
									
									else if (tag.einer == 9)
										{
											tag.einer = 0;
											tag.zehner++;
										}
										  else
											tag.einer++;
							        
							}
							else if ((monat.einer == 2) && (monat.zehner == 1))						// Dezember
								{
									if ((tag.einer == 1) && (tag.zehner == 3))						// Silvestercheck
									{
										tag.einer = 1;
										tag.zehner = 0;
										monat.einer = 1;
										monat.zehner = 0;
										
										if (jahr.einer == 9)											// Jahr weiterzhlen
										{
											jahr.einer = 0;
											jahr.zehner++;
										}
										else
											jahr.einer++;
									}
									else if (tag.einer == 9)
										{
											tag.einer = 0;
											tag.zehner++;
										}
										else
											tag.einer++;
								}
								else if ((tag.einer == 0) && (tag.zehner == 3))						// weder Monat mit 31 Tage, noch 
									{																	// Februar ==> Monat mit 30 Tagen
										tag.einer = 1;
										tag.zehner = 0;
										
										if (monat.einer == 9)
										{
											monat.einer = 0;
											monat.zehner = 1;
										}
										else
											monat.einer++;
									}
									else if (tag.einer == 9)
										{
											tag.einer = 0;
											tag.zehner++;
										}
										else
											tag.einer++;

					}
					else	if (stunde.einer == 9)														// kein Tagesberlauf
							{
								stunde.einer = 0;
								stunde.zehner++;
							}
							else
								stunde.einer++;
				}
			}
		}
	}
}

/*----------------------------------------------------------------------------
------------------Funktion fr rotierende Trennzeichen-----------------------*/
void dotright_dsp (void)						//Rechtsherum
{

	display_array[5]= 10+dot_count; 
	display_array[2]= 10+dot_count;

	dot_count++;												
	if (dot_count == 4)
	{
		dot_count = 0;
	}
}

void dotleft_dsp (void)							//Linksherum
{
	display_array[5]= 13-dot_count;
	display_array[2]= 13-dot_count;
	
	dot_count++;												
	if (dot_count == 4)
	{
		dot_count = 0;
	}
}

/*----------------------------------------------------------------------------
-----------------------------Taster Abfrage ---------------------------------*/
void taster (void)
{
	
	if(tast_count==0)
	{							
		if (TAST_1)									 // Abfrage von Taster 1 (MEN)				
		{
			tast_count = 500;					//Tastertiming
			menu_count++;				
			
			if (menu_count > 3)					// Festlegung der Anzahl von Menpunkten
			{
				menu_count = 0;
			}				 			
		}

		else if (TAST_2)							// Abfrage von Taster 2 (Start/Stop ; Akt/Deakt)
		{	
			tast_count = 500;					//Tastertiming
		
			if(menu_count == 2)					//EIERUHR
			{
				if(start_stop == 0)				//Eieruhr Starten/Stoppen
				{					
					start_stop = 1;
					TUBE_LIGHT_OFF();
					flag = 0;
				}
				else 
				start_stop = 0;
			}

			if(menu_count == 3)					//WECKER				
			{
				flag=1;
			
				if (wecker_active == 0)			//Wecker Aktivieren/Deaktivieren	
				{
					wecker_active = 1;
					TUBE_LIGHT_OFF();
					menu_count = 0;
				}
				else
				{
					wecker_active = 0;
				}
			}
		}
	
		else if (TAST_3)							// Abfrage von Taster 3 (Reset ; Sleep)
		{	
			tast_count = 500;					//Tastertiming
			if(menu_count == 2)					//EIERUHR
			{
				flag = 0;						//Eieruhr Reset			
				PORTD &= ~(1<<PD7);
				menu_count=0;					
			}

			if(menu_count == 3)					//WECKER				
			{
												///SLEEP FUNKTION ; COMMING SOON
			}
		}	
	
		else if (TAST_4)							// Abfrage von Taster 4 (Minute- ; Stunde-)
		{	
			tast_count = 150;					//Tastertiming
			if(menu_count == 2)						//EIERUHR
			{
				if (egg_minute.einer > 0)
					egg_minute.einer--;
				else
				{
					if (egg_minute.zehner > 0)
						{
							egg_minute.zehner--;
							egg_minute.einer = 9;
						}
					else
					{
						egg_minute.einer=0;
						egg_minute.zehner=0;
					}
				}
			}
			if(menu_count == 3)						//WECKER				
			{
				if (wecker_stunde.einer > 0)
					wecker_stunde.einer--;
				else
				{
					
					if (wecker_stunde.zehner > 0)
					{
						wecker_stunde.zehner--;
						wecker_stunde.einer = 9;
					}
					else
					{
						wecker_stunde.einer=0;
						wecker_stunde.zehner=0;
					}
				}
			}
		}
	
		else if (TAST_5)							// Abfrage von Taster 5 (Minute+ ; Stunde+)
		{	
			tast_count = 150;					//Tastertiming
			if(menu_count == 2)					//EIERUHR
			{
				if (egg_minute.einer < 9)		//Eieruhr Minute + einstellen										
					egg_minute.einer++;
				else
				{
					egg_minute.einer = 0;			
					if (egg_minute.zehner < 5)				
						egg_minute.zehner++;
					else
					{
						egg_minute.zehner=0;
						egg_minute.einer=0;
					}
				}
			}

			if(menu_count == 3)					//WECKER				
			{
				if (wecker_stunde.zehner < 2)	//Wecker Stunde + einstellen
				{
					if (wecker_stunde.einer < 9)											
						wecker_stunde.einer++;
					else
					{
						wecker_stunde.einer = 0;			
						if (wecker_stunde.zehner <2)				
							wecker_stunde.zehner++;
						else
						{
							wecker_stunde.zehner=0;
							wecker_stunde.einer=0;
						}
					}
				}
				else
				{
					if (wecker_stunde.einer < 3)											
						wecker_stunde.einer++;
					else
					{
						wecker_stunde.zehner=0;
						wecker_stunde.einer=0;
					}
				}
			}
		}
	
		else if (TAST_6)							// Abfrage von Taster 6 (Sekunde- ; Minute-)
		{	
			tast_count = 150;					//Tastertiming
			if(menu_count == 2)						//EIERUHR
			{
				if (egg_sekunde.einer > 0)
					egg_sekunde.einer--;
				else
				{
					if (egg_sekunde.zehner > 0)
						{
							egg_sekunde.zehner--;
							egg_sekunde.einer = 9;
						}
					else
					{
						egg_sekunde.einer=0;
						egg_sekunde.zehner=0;
					}
				}
			}
			
			if(menu_count == 3)						//WECKER				
			{
				if (wecker_minute.einer > 0)
					wecker_minute.einer--;
				else
				{
					
					if (wecker_minute.zehner > 0)
					{
						wecker_minute.zehner--;
						wecker_minute.einer = 9;
					}
					else
					{
						wecker_minute.einer=0;
						wecker_minute.zehner=0;
					}
				}
			}
		}

		else if (TAST_7)							// Abfrage von Taster 7 (Sekunde+ ; Minute+)
		{	

			tast_count = 150;					//Tastertiming
			if(menu_count == 2)						//EIERUHR
			{
				if (egg_sekunde.einer < 9)	//Eieruhr Sekunde + einstellen										
					egg_sekunde.einer++;
				else
				{
					egg_sekunde.einer = 0;			
					if (egg_sekunde.zehner < 5)				
						egg_sekunde.zehner++;
					else
					{
						egg_sekunde.zehner=0;
						egg_sekunde.einer=0;
					}
				}
			}

			if(menu_count == 3)						//WECKER				
			{
				if (wecker_minute.einer < 9)											
					wecker_minute.einer++;
				else
				{
					wecker_minute.einer = 0;			
					if (wecker_minute.zehner < 5)				
						wecker_minute.zehner++;
					else
					{
						wecker_minute.zehner=0;
						wecker_minute.einer=0;
					}
				}
			}	
		}
	}
	else
	{
		tast_count--;
		if (TAST_1)
		{
			light_count++;
			if(light_count==3000)
			{
				TOGGLE_TUBE_LIGHT();  
				light_count = 0;
				menu_count = 0;
				tast_count = 5000;
			}
		}
	}
}	
